module net.BurtonRadons.dig.platform.imageLoaderPNG;

private import net.BurtonRadons.dig.platform.base;
private import net.BurtonRadons.dig.common.imageLoader;
private import net.BurtonRadons.dig.common.color;
//private import std.stream;
//private import std.c.stdio;
//private import std.c.windows.windows;

alias int FILE; //Added by Joel Anderson

/+
#ifdef DOXYGEN_DOESN'T_WANT_THIS
+/

class digCommonImageLoader_png : ImageLoader
{
    private import net.BurtonRadons.dig.platform.windows;
    
    static private _HANDLE library;
    private const char[] libraryName = "libpng.dll";

    /* Returns success. */
    private static bit init()
    {
        if (library)
            return true;
        library = std.c.windows.windows.LoadLibraryA (libraryName);
        if (library == (_HANDLE) 0)
            return false;
        load ((void **) &png_create_info_struct, "png_create_info_struct");
        load ((void **) &png_create_read_struct, "png_create_read_struct");
        load ((void **) &png_create_write_struct, "png_create_write_struct");
        load ((void **) &png_destroy_read_struct, "png_destroy_read_struct");
        load ((void **) &png_destroy_write_struct, "png_destroy_write_struct");
        load ((void **) &png_get_IHDR, "png_get_IHDR");
        load ((void **) &png_get_PLTE, "png_get_PLTE");
        load ((void **) &png_get_io_ptr, "png_get_io_ptr");
        load ((void **) &png_get_text, "png_get_text");
        load ((void **) &png_init_io, "png_init_io");
        load ((void **) &png_read_image, "png_read_image");
        load ((void **) &png_read_info, "png_read_info");
        load ((void **) &png_read_row, "png_read_row");
        load ((void **) &png_set_IHDR, "png_set_IHDR");
        load ((void **) &png_set_packing, "png_set_packing");
        load ((void **) &png_set_read_fn, "png_set_read_fn");
        load ((void **) &png_set_sig_bytes, "png_set_sig_bytes");
        load ((void **) &png_set_strip_16, "png_set_strip_16");
        load ((void **) &png_set_text, "png_set_text");
        load ((void **) &png_set_write_fn, "png_set_write_fn");
        load ((void **) &png_sig_cmp, "png_sig_cmp");
        load ((void **) &png_write_end, "png_write_end");
        load ((void **) &png_write_image, "png_write_image");
        load ((void **) &png_write_info, "png_write_info");
        return true;
    }

    static void load (void **pointer, char [] name)
    {
        *pointer = std.c.windows.windows.GetProcAddress (library, std.string.toStringz (name));
        if (*pointer === null)
            throw new Error("couldn't find " ~ name ~ " in " ~ libraryName);
    }

    extern (C)
    {
        struct png_struct
        {
        }

        struct png_info
        {
        }

        struct png_text
        {
            int compression; /* compression value:
                               -1: tEXt, none
                                0: zTXt, deflate
                                1: iTXt, none
                                2: iTXt, deflate  */
            char *key; /* keyword, 1-79 character description of "text" */
            char *text; /* comment, may be an empty string (ie "") */
            int text_length; /* length of the text string */
            int itxt_length; /* length of the itxt string */
            char *lang; /* language code, 1-79 characters */
            char *lang_key; /* keyword translated UTF-8 string, 0 or more chars */
        }

        struct png_color
        {
            ubyte red;
            ubyte green;
            ubyte blue;
        }

        typedef void (*png_error) (png_struct *, char *);
        typedef void (*png_flush) (png_struct *);
        typedef void (*png_rw) (png_struct *, byte *, int);

        const char *PNG_LIBPNG_VER_STRING = "1.0.6";

        /* These describe the color_type field in png_info. */
        /* color type masks */
        const int PNG_COLOR_MASK_PALETTE = 1;
        const int PNG_COLOR_MASK_COLOR = 2;
        const int PNG_COLOR_MASK_ALPHA = 4;

        /* color types.  Note that not all combinations are legal */
        const int PNG_COLOR_TYPE_GRAY = 0;
        const int PNG_COLOR_TYPE_PALETTE = (PNG_COLOR_MASK_COLOR | PNG_COLOR_MASK_PALETTE);
        const int PNG_COLOR_TYPE_RGB = (PNG_COLOR_MASK_COLOR);
        const int PNG_COLOR_TYPE_RGB_ALPHA = (PNG_COLOR_MASK_COLOR | PNG_COLOR_MASK_ALPHA);
        const int PNG_COLOR_TYPE_GRAY_ALPHA = (PNG_COLOR_MASK_ALPHA);

        /* These are for the interlacing type.  These values should NOT be changed. */
        const int PNG_INTERLACE_NONE = 0; /* Non-interlaced image */
        const int PNG_INTERLACE_ADAM7 = 1; /* Adam7 interlacing */
        const int PNG_INTERLACE_LAST = 2; /* Not a valid value */

        /* This is for compression type. PNG 1.0-1.2 only define the std.math.single type. */
        const int PNG_COMPRESSION_TYPE_BASE = 0; /* Deflate method 8, 32K window */
        const int PNG_COMPRESSION_TYPE_DEFAULT = PNG_COMPRESSION_TYPE_BASE;

        /* This is for filter type. PNG 1.0-1.2 only define the std.math.single type. */
        const int PNG_FILTER_TYPE_BASE = 0; /* Single row per-byte filtering */
        const int PNG_FILTER_TYPE_DEFAULT = PNG_FILTER_TYPE_BASE;

        /* Supported compression types for text in PNG files (tEXt, and zTXt).
         * The values of the PNG_TEXT_COMPRESSION_ defines should NOT be changed. */
        const int PNG_TEXT_COMPRESSION_NONE_WR = -3;
        const int PNG_TEXT_COMPRESSION_zTXt_WR = -2;
        const int PNG_TEXT_COMPRESSION_NONE = -1;
        const int PNG_TEXT_COMPRESSION_zTXt = 0;
        const int PNG_ITXT_COMPRESSION_NONE = 1;
        const int PNG_ITXT_COMPRESSION_zTXt = 2;
        const int PNG_TEXT_COMPRESSION_LAST = 3;  /* Not a valid value */

        static
        {
            png_info *(*png_create_info_struct) (png_struct *png);
            png_struct *(*png_create_read_struct) (char *user_png_ver, void *error_ptr, png_error *error_fn, png_error *warn_fn);
            png_struct *(*png_create_write_struct) (char *user_png_ver, void *error_ptr, png_error *error_fn, png_error *warn_fn);
            void (*png_destroy_read_struct) (png_struct **png, png_info **info, png_info **end);
            void (*png_destroy_write_struct) (png_struct **png, png_info **info);
            uint (*png_get_IHDR) (png_struct *png, png_info *info, uint *width, uint *height, int *bit_depth, int *color_type, int *interlace_type, int *compression_type, int *filter_type);
            uint (*png_get_PLTE) (png_struct *png, png_info *info, png_color **palette, int *num_palette);
            void *(*png_get_io_ptr) (png_struct *png);
            uint (*png_get_text) (png_struct *png, png_info *info, png_text **text, int *num_text);
            void (*png_init_io) (png_struct *png, FILE *fp);
            void (*png_read_image) (png_struct *png, byte **image);
            void (*png_read_info) (png_struct *png, png_info *info);
            void (*png_read_row) (png_struct *png, ubyte *row, ubyte *display_row);
            void (*png_set_IHDR) (png_struct *png, png_info *info, uint width, uint height, int bit_depth, int color_type, int interlace_type, int compression_type, int filter_type);
            void (*png_set_packing) (png_struct *png);
            void (*png_set_read_fn) (png_struct *png, void *io_ptr, png_rw read_data_fn);
            void (*png_set_sig_bytes) (png_struct *png, int num_bytes);
            void (*png_set_strip_16) (png_struct *png);
            void (*png_set_text) (png_struct *png, png_info *info, png_text *text, int num_text);
            void (*png_set_write_fn) (png_struct *png, void *io_ptr, png_rw write_data_fn, png_flush output_flush_fn);
            int (*png_sig_cmp) (ubyte *sig, int start, int num_to_check);
            void (*png_write_end) (png_struct *png, png_info *info);
            void (*png_write_image) (png_struct *png, byte **image);
            void (*png_write_info) (png_struct *png, png_info *info);
        }
    }

    override char [] name () { return "PiNG"; }
    override char [] exts () { return "*.png;*.ping"; }
    
    override float match ()
    {
        ubyte [8] header;

        if (stream.read (header) != 8)
            return 0;
        if (header [0] != 0x89 || header [1] != 0x50 || header [2] != 0x4E || header [3] != 0x47)
            return 0;
        if (!init ())
            return 0;
        if (png_sig_cmp (header, 0, header.length))
            return 0;
        return 1;
    }

    static extern (C)
    void read_data (png_struct *png, byte *data, int length)
    {
        std.stream.Stream stream;

        stream = cast (std.stream.Stream) png_get_io_ptr (png);
        stream.readExact (data, length);
    }

    override void load ()
    {
        ubyte [8] header;

        if (stream.read (header) != 8 || !init ())
            throw new Error ("File is not a PNG image");
        assert (!png_sig_cmp (header, 0, header.length));

        /* Initial libpng bootup. */
        png_struct *png = png_create_read_struct (PNG_LIBPNG_VER_STRING, null, null, null);
        png_info *info = png_create_info_struct (png);

        if (info === null)
        {
            png_destroy_read_struct (&png, null, null);
            throw new Error ("couldn't allocate PNG info block");
        }
        
        png_info *end = png_create_info_struct (png);

        if (end === null)
        {
            png_destroy_read_struct (&png, &info, null);
            throw new Error ("couldn't allocate PNG end info block");
        }

        png_set_read_fn (png, (void *) stream, &read_data);
        //png_init_io (png, file);
        png_set_sig_bytes (png, header.length);

        /* Read all the file information up to the image data. */
        uint width; /* Width of the image in pixels. */
        uint height; /* Height of the image in pixels. */
        int depth; /* Bit depth of each channel (1, 2, 4, 8, or 16). */
        int colorType; /* Which color/alpha channels are present:
                          PNG_COLOR_TYPE_GRAY (depth 1, 2, 4, 8, 16)
                          PNG_COLOR_TYPE_GRAY_ALPHA (depth 8, 16)
                          PNG_COLOR_TYPE_PALETTE (depth 1, 2, 4, 8)
                          PNG_COLOR_TYPE_RGB (depth 8, 16)
                          PNG_COLOR_TYPE_RGB_ALPHA (depth 8, 16)

                        mask:
                          PNG_COLOR_MASK_PALETTE
                          PNG_COLOR_MASK_COLOR
                          PNG_COLOR_MASK_ALPHA
                        */
        int filterType; /* Must be PNG_FILTER_TYPE_BASE */
        int compressionType; /* Must be PNG_COMPRESSION_TYPE_BASE */
        int interlaceType; /* PNG_INTERLACE_NONE or PNG_INTERLACE_ADAM7 */
        int pitch; /* Bytes per line. */

        png_read_info (png, info);
        png_get_IHDR (png, info, &width, &height, &depth, &colorType,
                      &interlaceType, &compressionType, &filterType);

        /* Start the image data. */
        char [] dtype;
        bit dalpha;

        if (depth < 8 && image.prefer8to124 ())
            png_set_packing (png);
        if (depth > 8 && image.prefer8to16 ())
            png_set_strip_16 (png);

        png_get_IHDR (png, info, &width, &height, &depth, &colorType,
                      &interlaceType, &compressionType, &filterType);

        switch (colorType)
        {
            case PNG_COLOR_TYPE_GRAY: dtype = "luminance"; break;
            case PNG_COLOR_TYPE_GRAY_ALPHA: dtype = "luminance"; dalpha = true; break;
            case PNG_COLOR_TYPE_PALETTE: dtype = "index"; break;
            case PNG_COLOR_TYPE_RGB: dtype = "rgb"; break;
            case PNG_COLOR_TYPE_RGB_ALPHA: dtype = "rgb"; dalpha = true; break;
        }

        image.dimensions (width, height, depth, dtype, dalpha);
        image.topdown ();

        if (dtype == "index")
        {
            Color [] palette;
            png_color *colors;
            int count;

            png_get_PLTE (png, info, &colors, &count);
            palette.length = count;
            for (int c; c < count; c ++)
                palette [c] = AColor (colors [c].red, colors [c].green, colors [c].blue);
            image.paletteColors (palette);
        }

        ubyte [] line = new ubyte [image.bytesPerRow ()];

        for (int y; y < height; y ++)
        {
            png_read_row (png, line, null);
            image.row (y, line);
        }

        png_destroy_read_struct (&png, &info, &end);
        delete line;
    }
}

/+
#endif
+/